#   pytsipchat.py is part of PyTSIPChat - a software written in Python to 
#   communicate with the Trimble Products that use the proprietary TSIP protocol.
#
#   Copyright (C) 2014 Fernando P. Hauscarriaga <fernandoph@iar.unlp.edu.ar>
#
#   PyTSIPChat is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   PyTSIPChat is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with PyTSIPChat.  If not, see <http://www.gnu.org/licenses/>.

import cmd
import copy
import serial
from time import sleep

from TSIP.TSIPDevice import TSIPDevice
from TSIP.TSIPPacket import TSIPPacket
from TSIP.PacketsDefinitions import *

introtext = '\n\
========================== Welcome to TsipChat ============================ \n\
\n\
Developed by: \n\
             Fernando P. Hauscarriaga <fernandoph@iar.unlp.edu.ar> \n\n\
Sponsored by: \n\
             Instituto Argentino de Radioastronomia \n\
              (http://www.iar.unlp.edu.ar)\n\
             Comision Nacional de Investigaciones Cientificas y Tecnicas\n\
              (http://www.conicet.gov.ar)\n\
             Trimble Navigation LTD \n\
              (http://www.trimble.com)\n\
\n\
         PyTSIPChat Copyright (C) 2014 Fernando P. Hauscarriaga \n\
         This program comes with ABSOLUTELY NO WARRANTY.\n\
         This is free software, and you are welcome to redistribute it\n\
         under certain conditions.\n\
\n\
Type \'help\' for help\n\
=========================================================================== \n\
\n '

# TSIP Commands and SuperCommands for prompt completion
request_completions = []
for key in TSIPCMD.keys():
    request_completions.append(TSIPCMD[key][4])

for key in TSIPSUPERCMD.keys():
    request_completions.append(TSIPSUPERCMD[key][4])


class PyTSIPChat(cmd.Cmd):
    """Simple command processor example."""
    def __init__ (self):
        cmd.Cmd.__init__(self)
        self.prompt = '[TsipChat]> '
        self.tsipdevice = TSIPDevice()

    def do_list_commands(self, line):
        cmds      = copy.deepcopy(TSIPCMD)
        supercmds = copy.deepcopy(TSIPSUPERCMD)
        
        print 'Commands:'
        for cmd in cmds.keys():
            print '%s - %s' % (cmds[cmd][4], cmds[cmd][0])
        print ''
        print 'Super Commands:'
        for cmd in supercmds.keys():
            print '%s - %s' % (supercmds[cmd][4], supercmds[cmd][0])

        del cmds, supercmds

    def do_connect(self, line):
        if line:
            try:
                fd = serial.Serial(port = line, baudrate=9600, bytesize=8, 
                                   parity=serial.PARITY_ODD, stopbits=1, 
                                   timeout=0.1, xonxoff=False, rtscts=False, 
                                   dsrdtr=False)

                fd.close()

                settings = fd.getSettingsDict()

                print '\nSerial port configuration:'
                for config in settings.keys():
                    print config, settings[config]

                while True:
                    print '\nDo you want to change the configuration? <y/[N]>: ',
                    answer = raw_input()
                    if answer not in ['y', 'n', 'Y', 'N', '']:
                        print 'Please say y or n ...'
                    else:
                        break

                if answer in ['y', 'Y']:
                    while True:
                        while True:
                            config = raw_input('What do you want to change?: ')
                            if settings.has_key(config):
                                nwconfig = raw_input(config+': ')
                                # prompt new config
                                settings[config] = eval(nwconfig)
                                fd.applySettingsDict(settings)
                                break
                            else:
                                print 'Please say what you want to change...'
                        while True:
                            print '\nSerial port configuration:'
                            for config in fd.getSettingsDict().keys():
                                print config, fd.getSettingsDict()[config]
                            print 'Do you want to change something else? <y/[N]>:',
                            answer = raw_input()
                            if answer not in ['y', 'n', 'Y', 'N', '']:
                                print 'Please say y or n ...'
                            else:
                                break
                            
                        if answer in ['n', 'N', '']:
                            break

                print 'Add', line, 'port to TSIPDevice ... ',
                self.tsipdevice.addPort(fd)
                print 'Done.'
                
                print 'Opening All added ports ... ',
                self.tsipdevice.openPorts()
                print 'Done.'

            except IOError:
                print 'Could not configure serial port', line, 'check serial port name and path...'
         
        else:
            print 'Please name a serial port complete path...'
            return

    def do_readdevice(self, line):
        packets = self.tsipdevice.readPorts()

        for packet in packets:
            print "==== %s - Id: 0x%02X ====" % (packet.getDescription(), 
                                             ord(packet.getId()))
            for key in packet.fields.keys():
                print packet.fields[key][0],":", packet.fields[key][1]
            print ""
        return

    def do_request(self, line):
        if line:
            if cmdshortcuts.has_key(line):
                # it's a command
                print 'Command', line
                cmd = copy.deepcopy(TSIPCMD[cmdshortcuts[line]])
            elif supercmdshortcuts.has_key(line):
                # it's a supercommand
                print 'SuperCommand', line
                cmd = copy.deepcopy(TSIPSUPERCMD[supercmdshortcuts[line]])
            else:
                # Command not in list
                print 'Command not found'
                return
            
            cmdargs = cmd[2]

            for byte in cmdargs.keys():
                if cmdargs[byte][1] == None:
                    print '\nPlease specify command arguments:'
            
            for byte in cmdargs.keys():
                if cmdargs[byte][1] == None:
                    if cmd[3].keys():
                        print cmdargs[byte][0]+'...'
                        for option in cmd[3][byte].keys():
                            print option, ':', cmd[3][byte][option]
                        while True:
                            cmd[2][byte][1] = input (cmdargs[byte][0]+': ')
                            if cmd[2][byte][1] <> '': break

            print '\nPlease check command arguments before send...'
            for byte in cmd[2].keys():
                print byte, '-', cmd[2][byte][0], ':', cmd[2][byte][1]

            while True:
                print '\nSend Command ? <y/[N]>: ',
                answer = raw_input()
                if answer not in ['y', 'n', 'Y', 'N', '']:
                    print 'Please say y or n ...'
                else:
                    break

            if answer in ['n', 'N', '']:
                print 'Command not sent...'
                del cmd, cmdargs
                return
            elif answer in ['y', 'Y']:
                tsippacket = TSIPPacket(packet=cmd)
                self.tsipdevice.writePort(self.tsipdevice.getPorts()[0], tsippacket)
                print 'Packet', tsippacket.getDescription(), 'sent...'
                sleep(0.5)
                self.do_readdevice(line)
                del cmd, cmdargs, tsippacket
                return 

        else:
            print 'Use: request <command | supercommand>'
            self.do_list_commands(line)
            return 

    def do_exit(self, line):
        return True

    def do_quit(self, line):
        return True

    def do_EOF(self, line):
        return True
    
    def postloop(self):
        print 'Closing opened ports ... ',
        self.tsipdevice.closePorts()
        print 'Done.'
        print 'Cleanup ... ',
        if self.tsipdevice:
            del self.tsipdevice
        print 'Done.'
        print '\nGoodbye! :)'

    # Thanks to goo.gl/UyRQ7W
    def complete_request(self, text, line, begidx, endidx):
        mline = line.partition(' ')[2]
        offs = len(mline) - len(text)
        return [s[offs:] for s in request_completions if s.startswith(mline)]

if __name__ == '__main__':
    PyTSIPChat().cmdloop(intro=introtext)
