#   testcase_TSIPDevice.py is part of PyTSIPChat - a software written in 
#   Python to communicate with the Trimble Products that use the proprietary
#   TSIP protocol.
#
#   Copyright (C) 2014 Fernando P. Hauscarriaga <fernandoph@iar.unlp.edu.ar>
#
#   PyTSIPChat is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   PyTSIPChat is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with PyTSIPChat.  If not, see <http://www.gnu.org/licenses/>.

import serial
import copy
from time import sleep
from TSIPDevice import TSIPDevice
from TSIPPacket import TSIPPacket
from PacketsDefinitions import *


def readallports(acutimegg):
    packets = acutimegg.readPorts()

    for packet in packets:
        print "==== %s - Id: 0x%02X ====" % (packet.getDescription(), 
                                             ord(packet.getId()))
        for key in packet.fields.keys():
            print packet.fields[key][0],":", packet.fields[key][1]
        print ""

# A TSIP Device
acutimegg = TSIPDevice()

# Its ports
fd0 = serial.Serial(port='/dev/ttyMI0', baudrate=115200, bytesize=8, 
                    parity=serial.PARITY_ODD, stopbits=1, timeout=0.1,
                    xonxoff=False, rtscts=False,dsrdtr=False)

fd1 = serial.Serial(port='/dev/ttyMI1', baudrate=115200, bytesize=8, 
                    parity=serial.PARITY_ODD, stopbits=1, timeout=0.1,
                    xonxoff=False, rtscts=False,dsrdtr=False)

# Add ports to the TSIP Device
#acutimegg.addPort(fd0)
acutimegg.addPort(fd1)

# Example write
pk = copy.deepcopy(TSIPSUPERCMD[0xAC])
pk[2][2][1] = 2
tsippacket = TSIPPacket(packet=pk)


acutimegg.openPorts()
acutimegg.writePort(fd1, tsippacket)
#readallports(acutimegg)
#acutimegg.closePorts()
print acutimegg.getAvalCmds()

# Read loop on all ports
#while True:
 #   readallports(acutimegg)
