#   TSIPPacket.py is part of PyTSIPChat - a software written in Python to 
#   communicate with the Trimble Products that use the proprietary TSIP protocol.
#
#   Copyright (C) 2014 Fernando P. Hauscarriaga <fernandoph@iar.unlp.edu.ar>
#
#   PyTSIPChat is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   PyTSIPChat is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with PyTSIPChat.  If not, see <http://www.gnu.org/licenses/>.

from PacketsDefinitions import *
import struct

# "Constants"
EMPTY = 0x0
FULL  = 0x1
DLE1  = 0x2
DATA  = 0x3
DLE2  = 0x4

# Packet delimiter special characters
DLE     = 0x10
ETX     = 0x03
SUPERPK = 0x8F


class TSIPPacket(object):
#===============================================================================
# Class Constructor and object properties definitions
    def __init__(self, packet = None):
        self.subPacketId = None
        self.id          = None
        self.description = None
        self.length      = 0
        self.data        = ''    # Raw data
        self.packet      = None  # Formed packet (the dictionary definition)
        self.fields      = None  # Only dictionary fields
        self.flags       = None  # Flags for some of the fields (where 
                                 # available)
        if packet != None:
            self.packet = packet
            self.initPacket()
        
#================================= Methods =====================================
# Getters
    def getSubPacketId (self):
        return self.subPacketId

    def getId(self):
        return self.id

    def getDescription(self):
        return self.description

    def getLength(self):
        return self.length

    def getData(self):
        return self.data
        
    def getPacket(self):
        return self.packet

    def getFields(self):
        return self.fields

    def getFlags(self):
        return self.flags

# Setters
    def setSubPacketId(self, aSubId):
        self.subPacketId = aSubId

    def setId(self, anId):
        self.id = anId

    def setDescription(self, aDescription):
        self.description = aDescription

    def setLength(self,  aLength):
        self.length = aLength

    def setData(self, someData):
        self.data = someData

    def setFields(self, fieldData):
        self.fields = fieldData

    def setFlags(self, flagsData):
        self.flags = flagsData
    
    def clearPacket(self):
        self.data     = ''
        self.setLength (0)
        self.packet   = None

# Functionality
    def initPacket(self):
        if self.getPacket()[2][0][1] == 0x8E:
            self.setSubPacketId(0x8E)
            self.setId(self.getPacket()[2][1][1])
        else:
            self.setSubPacketId(False)
            self.setId(self.getPacket()[2][0][1])

        self.setDescription(self.getPacket()[0])
        self.setFields(self.getPacket()[2])
        self.setFlags(self.getPacket()[3])
    

    def encodePacket(self, aListOfBytes):
        pass

    def buildPacket(self,  aByte):
        pass

    def getAvalCmds(self):
        cmdlist = []

        for key in TSIPSUPERCMD.keys():
            cmdlist.append("0x8E-%02X - %s" % (key, TSIPSUPERCMD[key][0]))

        return cmdlist

    def interpret(self, aRawPacket):
        self.setLength(len(aRawPacket))
        self.setData(aRawPacket)

        # If it's a SuperPacket
        if ord(aRawPacket[0]) == 0x8F:

            # If it's on the dictionary
            if TSIPSUPERPK.has_key(ord(self.getData()[1])):
                self.packet   = TSIPSUPERPK[ord(aRawPacket[1])][:]
                self.setSubPacketId(self.getData()[0])
                self.setId (self.getData()[1])
            else:
                print 'Super packet not in dict 0x%02X' % ord(self.getData()[1])
                return None  # FIXME: Should be raising an exception

        else: # if it's a report packet

            # if it's on the dictionary
            if TSIPRPT.has_key(ord(self.getData()[0])):
                self.packet   = TSIPRPT[ord(aRawPacket[0])][:]
                self.setId (self.getData()[0])
            else:
                print 'Packet not in dict 0x%02X' % ord(self.getData()[0])
                return None  # FIXME: Should be raising an exception

        # All is well, now it's time to interpret the packet according
        # to it's internal structure
        data = struct.unpack(self.packet[1], self.getData()[1:])
        
        # Some housekeeping
        if self.packet != None:
            # And now fill out packet internal fields
            for key in self.packet[2].keys():
                self.packet[2][key][1] = data[key]

            # Set fields and flags and other stuff
            self.setFields(self.packet[2])
            self.setFlags (self.packet[3])
            self.setDescription (self.packet[0])
            
            return True


        return None
 
