#   PacketsDefinitions.py is part of PyTSIPChat - a software written in 
#   Python to communicate with the Trimble Products that use the proprietary
#   TSIP protocol.
#
#   Copyright (C) 2014 Fernando P. Hauscarriaga <fernandoph@iar.unlp.edu.ar>
#
#   PyTSIPChat is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   PyTSIPChat is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with PyTSIPChat.  If not, see <http://www.gnu.org/licenses/>.



# TSIP Data Types
#Data type Description
#U8        An 8- bit unsigned number (0 to 255)
#S8        An 8-bit signed number (-128 to 127)
#I16       A 16-bit unsigned number (0 to 65,535)
#S16       An 16-bit signed number (-32,768 to 32,767)
#U32       A 32-bit unsigned number (0 to 4,294,967,295)
#S32       A 32-bit signed number (-2,147,483,648 to 2,147,483,647
#          Single - Float (4 bytes) (3.4x10-38 to 1.7x1038) (24 bit precision)
#          Double - Float (8 bytes) (1.7x10-308 to 3.4x10308) (53 bit precision)

# {CMDCode, [Description, 
#            String_for_PyStruct
#            {Dictionary containing Items defininitions},
#            {Dictionary containing any status flags needed},
#] 
#}

# TSIP Report Packets =========================================================
TSIPRPT = {
    0x32 : ['Accurate Inital Position', 
            '>BB',
            {0 : ['Status',   None], 
             1 : ['Reserved', None]
             },
            { }
            ],
    
    0x40 : ['Almanac Data Page Report', 
            '>Bfhffffffff',
            {0  : ['Satellite',     None],
             1  : ['T_zc',          None],
             2  : ['Week Numb.',    None],
             3  : ['Eccentricity',  None],
             4  : ['T_oa',          None],
             5  : ['i_o',           None],
             6  : ['OMEGA_dot',     None],
             7  : ['square_root_A', None],
             8  : ['OMEGA_O',       None],
             9  : ['Omega',         None],
             10 : ['M_O',           None]
             },
            { }
            ],
    
    0x43 : ['Velocity FIX XYZ ECEF', 
            '>fffff',
            {0 : ['X Velocity',     None],
             1 : ['Y Velocity',     None],
             2 : ['Z Velocity',     None],
             3 : ['bias rate',      None],
             4 : ['time-of-fix',    None]
             },
            { }
            ],

    0x45 : ['Software Version Information',
            '>BBBBBBBB',
            {0 : ['Major version number of application', None],
             1 : ['Minor version number',                None],
             2 : ['Month',                               None],
             3 : ['Day',                                 None],
             4 : ['Year number minus 2000',              None],
             5 : ['Major revision number of GPS core',   None],
             6 : ['Minor revision number',               None],
             7 : ['Month',                               None],
             8 : ['Day',                                 None],
             9 : ['Year number minus 2000',              None]
             },
            { }
            ],

    0x54 : ['Bias and Bias Rate Report',
            '>fff',
            {0 : ['Bias',           None],
             1 : ['Bias rate',      None],
             2 : ['Time of fix',    None]
             },
            { }
            ]
    }


TSIPSUPERPK = {
    0xAB : ['Primary Timing Packet',
            '>BIHhBBBBBBH',
            {0  : ['Subpacket Id',    0xAB],
             1  : ['Time of Week',    None],
             2  : ['Week Number',     None],
             3  : ['UTC Offset',      None],
             4  : ['Timing Flag',     None],
             5  : ['Seconds',         None],
             6  : ['Minutes',         None],
             7  : ['Hours',           None],
             8  : ['Day of Month',    None],
             9  : ['Month',           None],
             10 : ['Year',            None]
             },
            { },
            ],

    0xAC : ['Supplemental Timing Packet',
            '>BBBBIHHBBBBffIffdddfI',
            {0  : ['Subpacket Id',           0xAC],
             1  : ['Receiver Mode',          None],
             2  : ['Reserved',               None],
             3  : ['Self-Survey Progress',   None],
             4  : ['Reserved',               None],
             5  : ['Reserved',               None],
             6  : ['Minor alarms',           None],
             7  : ['GPS Decoding Status',    None],
             8  : ['Reserved',               None],
             10 : ['PPS Indication',         None],
             11 : ['Reserved',               None],
             12 : ['Local clock bias',       None],
             13 : ['Local clock bias rate',  None],
             14 : ['Reserved',               None],
             15 : ['Reserved',               None],
             15 : ['Temperature',            None],
             16 : ['Latitude',               None],
             17 : ['Longitude',              None],
             18 : ['Altitude',               None],
             19 : ['PPS Quantization Error', None],
             20 : ['Reserved',               None]
             },
            { },
            ],
    0xAD : ['Primary UTC Time',
            '>BhdBBBBBhBBBB',
            {0  : ['Subpacket Id',    0xAD],
             1  : ['Event Count',     None],
             2  : ['Frac. Second',    None],
             3  : ['Hour',            None],
             4  : ['Minute',          None],
             5  : ['Second',          None],
             6  : ['Day',             None],
             7  : ['Month',           None],
             8  : ['Year',            None],
             9  : ['Receiver Status', None],
             10 : ['UTC Flags',       None],
             11 : ['Reserved',        None],
             12 : ['Reserved',        None]
             },
            {9  : {0 : 'DOING_FIXES',
                   1 : 'GOOD_1DV',
                   2 : 'APPX_1SV',
                   3 : 'NEED_TIME',
                   4 : 'NEED_INITIZALIZATION',
                   5 : 'PDOP_HIGH',
                   6 : 'BAD_1SV',
                   7 : '0SVs',
                   8 : '1SV',
                   9 : '2SVs',
                   10: '3SVs',
                   11: 'NO_INTEGRITY',
                   12: 'DCORR_GEN',
                   13: 'OVERDET_CLK',
                   },
             10 : {1  : 'UTC_FLAG',
                   2  : '',
                   4  : '',
                   8  : '',
                   16 : 'Leap_Scheduled',
                   32 : 'Leap Pending',
                   64 : 'GPS Leap Warning',
                   128: 'Leap in Progress'
                   }
             }
            ]
    }

# TSIP Command Packets ========================================================
TSIPCMD = {
    0x1F : ['Request Software Version',
            '>B',
            { 0 : ['Packet ID',    0x1F]},
            { },
            'swver'
            ]
    }

TSIPSUPERCMD = {
    0xAB : ['Request Primary Timing Packet', 
            '>BBB',
            {0 : ['Packet Id',     0x8E],
             1 : ['Subpacket Id',  0xAB],
             2 : ['Request type',  None]
             },
            {2: {0 : '0x8F-AB Inmediately',
                 1 : '0x8F-AB on-time next second',
                 2 : '0x8F-AB and 0x8F-AC on-time next second'
                 },
             },
            'primtiming'
            ],
    0xAC : ['Request Supplemental Timing Packet',
            '>BBB',
            {0 : ['Packet Id',     0x8E],
             1 : ['Subpacket Id',  0xAC],
             2 : ['Request Type',  None],
             },
            {2 : {0 : 'Send 0x8F-AC immediately',
                  1 : 'Send 0x8F-AC on-time next second',
                  2 :  'Send 0x8F-AB and 0x8F-AC on-time next second',
                  },
             },
            'supptiming'
            ]
    }

# Commands shortcuts or "reverse" dictionary
cmdshortcuts = {}
for key in TSIPCMD.keys():
    cmdshortcuts[TSIPCMD[key][4]] = key

supercmdshortcuts = {}
for key in TSIPSUPERCMD.keys():
    supercmdshortcuts[TSIPSUPERCMD[key][4]] = key
