

#include <stdio.h>
#include "novas.h"


int main (void)
{
	double gst;
	short int year, month, day;
	double hour;
	double tjd;
	double ra = 10.0 + (45.0 + 04.0/60.0)/60.0 ;
	double dec= -(59.0 + (41.0 + 04.0/60.0)/60.0);
	double zd, az, rar, decr;
	short int ref_option = 0;
	site_info geo_loc = {
		-(34.0 +(54.0 + 24.3040/60.0)/60.0),
		-(57.0 +(55.0 + 56.2782/60.0)/60.0),
		20.0, 20.0, 1010.0};
	body earth;
	cat_entry stars = {"n", 
			   "Eta CAR", 1, 
			   10.0 + (45.0 + 04.0/60.0)/60.0,
			   -(59.0 + (41.0 + 04.0/60.0)/60.0),
			   0.0,  0.0,  0.0,  0.0};
	
	set_body (0,3,"Earth", &earth);
	cal_date( 2453369.7741, &year, &month, &day, &hour);
	//cal_date( 2453369.565304, &year, &month, &day, &hour);
	
	year = 2004;
	month = 12;
	day = 30;
	hour = 3.0 + 3.578400;
	
	tjd = julian_date(year, month, day, hour);
	//tjd = julian_date(2005, 1, 1, 0.0);
	
	sidereal_time (tjd,0.0, 0.0, &gst);
	
	printf(" %04d/%02d/%02d %f, DJ = %f, st = %f - RA: %f, DEC: %f\n", 
	       year, month, day, hour,
	       tjd, 
	       gst + geo_loc.longitude/15.0,
	       ra, dec
		);

	//topo_star (tjd, &earth, 0.0, &stars, &geo_loc, &ra, &dec);
	
	equ2hor (tjd, 32.184 + 38.0, 0.0, 0.0,
		 &geo_loc,
		 ra, dec, ref_option,
		 &zd, &az, &rar, &decr);
	
	/* az: Topocentric azimuth (measured east from north) in
	   degrees.  */

	printf( "RA: %f, DEC: %f, z: %f, az: %f\n", 
		ra, dec, zd, az +180.0
		);
	topo_star (tjd, &earth, 0.0, &stars, &geo_loc, &ra, &dec);

	printf( "RA: %f, DEC: %f\n", ra, dec);

	return 0;
}
