/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 *   TODO: ???
 *      *)
 *      *)
 **/

#ifndef NODAEMON
#  define DAEMON
#endif

#include <errno.h> 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/socket.h>

#include "socket_srv.h"
#include "socket_client.h"
#include "my_stdio.h"
#include "iar_bus.h"
#define USE_IAR_BUS
#include "camera.h"



void fireman(int s)
{ 
	int wstatus;

	while(wait3(&wstatus, WNOHANG, NULL) > 0);
}


int cartel(int fd, char *prefix)
{
	fd_printf(fd, "%sIAR CCD Camera acquisition system.\n", prefix);
	fd_printf(fd, "%s\n", prefix);

	return 0;
}


int main(int argc, char *argv[]) 
{
	int cam;
	int fd;
	int pid;
	//char *cp;
	int op;
	static struct option  const  longopts[] =
	{
		{"help", 0, 0, 'h'},
		{"verbose", 0, 0, 'v'},
		{0,  0,  0,  0}
	};
	
	struct ib_command cm[] = {
		{IB_CM_MESSAGE, ib_cm_message},
		{IB_CM_MESSAGE_TO, ib_cm_message_to},
		{IB_CM_REMOVE,  ib_cm_remove},
		{IB_CM_ON,      ib_cm_on},
		//{IB_CM_OFF,     ib_cm_off},
		//{IB_CM_RW,      ib_cm_rw},
		{IB_CM_SET_ADDR, ib_cm_set_addr},
		{-1, NULL}
	};


	opterr =  0;
	while  ((op = getopt_long(argc, argv, "vh",longopts, 0)) != EOF)
		switch( op ){
		case 'v':
			verbose_flag = (verbose_flag << 1) | 1;
			break;
		case 'h':
			//usage();
			//help();
			exit(-1); 
		default:
			//usage();
			exit(-1);
		}
	
	if ( (pid=fork()) == 0 ) {
		init_iar_bus_inet( cm, CAMERA_TCP_PORT );
		exit(0);
	}

	usleep(100); /* wait for bus startup */
	
	/* camera: registry on bus */
	fd = call_socket(CAMERA_HOST_NAME, CAMERA_TCP_PORT);
	if (fd < 0 ) exit(1);
	if ( ibus_set_addr(fd, CC_IB_ID) != CC_IB_ID) {
		PVERB(PERR,"camera registry addr on iar bus falled.");
		exit(1);
	}
#ifdef DAEMON
	pid = fork();
#else
	pid = 0;
#endif
	if ( pid == 0 ) {
		/* open camera: */
		cam = open_camera();
		ibus_on( fd );
		if ( camera_core(cam, fd) == -1){
			PVERB(PERR,"main_d->camera");
			exit(1);
		}
		ibus_remove( fd );
		close( fd );
		exit(0);
	}
	close( fd );

	return 0;

}




