/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2005 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/
#define _GNU_SOURCE

#ifdef USE_XPA
#include <stdio.h>
#include <stdlib.h>
#include <xpa.h>
#include <unistd.h>
#include <limits.h>

#include "my_stdio.h"

#define NXPA 10

static XPARec *xpa = NULL;
static char *xtemplate="ds9";
static retry_ds9 = 1;


static pid_t my_exec(char *command)
{
	pid_t pid;
	
	if (command == 0)
		return 1;
	pid = fork();
	if (pid == -1)
		return -1;
	if (pid == 0) {
		char *argv[4];
		argv[0] = "sh";
		argv[1] = "-c";
		argv[2] = command;
		argv[3] = 0;
		if( execve("/bin/sh", argv, environ) == -1){
			perror("execve");
			exit(1); /* ojo: execve no retorna si tiene exito. */
		}
		exit(127);
	}
	return pid;
}


int caxpa_open(void)
{
	xpa = XPAOpen(NULL);
#if 0
	if((xpa = XPAOpen(NULL)) == NULL) {
		fprintf(stderr, "ERROR: can't open conection\n");
		return -1;
	}
#endif
	return 0;
}


int caxpa_display( char *filename)
{
	int i;
	int got;
	char *names[NXPA];
	char *messages[NXPA];
	char paramlist[_POSIX_PATH_MAX + 8];
	char *path;
	int ret = 0;

	if (filename[0] == '/') {
		path = "";
	}else{
		path = getenv("PWD");
	}
	sprintf(paramlist,"file %s/%s", path, filename );
	got = XPASetFd(xpa, xtemplate, paramlist, NULL, -1, 
		       names, messages, NXPA);
	for(i=0; i<got; i++){
		if( messages[i] != NULL ){
			/* error processing */
			fprintf(stderr, "CAXPA ERROR: %s (%s)\n", 
				messages[i], names[i]);
			ret = -1;
		}
		if( names[i] )
			free(names[i]);
		if( messages[i] )
			free(messages[i]);
	}
	if(got == 0) {/* FIXME  */
		fprintf(stderr, "ERROR\n");
		ret = -1;
	}
	if(ret != 0 && retry_ds9) {
		retry_ds9--;
		my_exec("ds9");
		sleep(1);
		ret = caxpa_display(filename);
		if ( ret == 0 )
			retry_ds9 = 1;
	}
	return ret;
}

int caxpa_close(void)
{
	XPAClose(xpa);
	
	return 0;
}


#endif
