/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2005 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include "my_stdio.h"

#include "camera.h"
#include "fits_io.h"
#include "camera_tools.h"
#include "version.h"


int ct_read_save_file(int cam, char *filename)
{
	int len ;
	int *data;
	int status;
	struct image_2d im;

	if ( cc_act_rcv_setup(cam, &im.s) < 0) {
		PVERB(PINFO, " Error reading image setup.\n");
		return CT_IM_SETUP;
	}
	len = im.s.naxis2 * im.s.naxis1;
	if ( im.s.naxis2 > CCD_Y_LEN || im.s.naxis2 <= 0 ||  /* 384 */
	     im.s.naxis1 > CCD_X_LEN || im.s.naxis1 <= 0 ) { /* 576 */
		PVERB(PINFO, " invalid dimension %d x %d data image\n",
		      im.s.naxis2, im.s.naxis1);
		return CT_IM_DIM;
	}
	data = (int *) malloc(len * sizeof(int));
	PVERB(PINFO, " geting %d x %d data image: ", im.s.naxis2, im.s.naxis1);
	if ( cc_act_rcv_data(cam, data, &len) < 0) {
		PVERB(PINFO, " Error reading image.\n");
		free(data);
		return CT_IM_READ;
	}
	im.data = data;
	sprintf(im.comment,
		"stari camera control v %s, (c) Federico A. Bareilles (License GPL)", VERSION);
	
	status = image_2d_save(filename, &im);
	free(data);
	if (status != 0) {
		PVERB(PINFO, " Fail.\n");
		fits_report_error(stdout, status);
		return CT_IM_FITS_ERR;
	}

	PVERB(PINFO, "ok.\n");
	return CT_IM_OK;
}


int ct_read_header_file(char *filename)
{
	/* FIXME: 

	   falta la lectura del archivo de header para la
	   imagen. puede que filename convenga definirlo en
	   camera_tools.h. Debe ser leido cada vez que se guarda una
	   imagen y debe lamarse esta funcion desde
	   ct_read_save_file() para agragar la info en la struct
	   image_2d.
	   
	   Hay que modificar image_2d_save() para que incluya los
	   parametros del header.

	*/

	

}
