/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/

#ifndef _CAMERA_SETUP_H
#define _CAMERA_SETUP_H

#define IMT_NONE  0
#define IMT_IMAGE 1
#define IMT_DARK  2
#define IMT_BIAS  3
#define IMT_FOCUS 4
#define IMT_SHADE 5
#define IMT_CLEAR 6
#define IMT_FLATT 7 /* Not implemented */


struct camera_setup {
	int im_type;
	int naxis1;
	int naxis2;
	double exposure;
	int gain;
	int temperature;
};

int camera_get_setup(int dev, int im_type);
int camera_current_setup(int dev, struct camera_setup *s);

#endif /* _CAMERA_SETUP_H */
