/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2005 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/

#define _GNU_SOURCE

#define HW_GPIB
#include "camera.h"
//#include "my_stdio.h"
#include "camera_setup.h"

static struct camera_setup cam_setup;


int camera_get_setup(int dev, int im_type)
{
	int exposure;
	int ret;

	cam_setup.im_type = im_type;
#ifdef DEMO_MODE
	cam_setup.naxis2 = 384; 
	cam_setup.naxis1 = 576;
	exposure = 3;
	cam_setup.exposure = (double) exposure / 10.0;
	cam_setup.gain = 4;
	cam_setup.temperature = -53;
	ret = 0;
#else
	ret = get_int_from_cc(dev, "G", &cam_setup.naxis1);
	if (ret >= 0) ret = get_int_from_cc(dev, "F", &cam_setup.naxis2);
	if (ret >= 0) {
		ret = get_int_from_cc(dev, "A", &exposure); 
		cam_setup.exposure = (double) exposure / 10.0;
	}
	if (ret >= 0) {
	  ret = get_int_from_cc(dev, "B", &cam_setup.gain);
	  switch(cam_setup.gain){
	  case 0: cam_setup.gain = 1; break;
	  case 1: cam_setup.gain = 4; break;
	  default: 
	    cam_setup.gain = 0;
	  }
	}
	if (ret >= 0) ret = get_int_from_cc(dev, "T", &cam_setup.temperature);
#endif

	return ret;
}


int camera_current_setup(int dev, struct camera_setup *s)
{
	/* dev is ignored */
	memcpy(s, &cam_setup, sizeof(struct camera_setup));
	
	return 0;
}

