/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <time.h>
//#include <stdarg.h>
#include <unistd.h>
#include <malloc.h>
//#include <stdint.h>
#include "iar_bus.h"
#define USE_IAR_BUS
#  include "camera.h"
#include "camera_ib_pk.h"
#include "my_stdio.h"



static ssize_t soft_read( int fd, void *buf, size_t count)
{
        fd_set rfds;
        int fd_max = fd + 1;
        int retval;
	struct timeval tv;

	while( 1 ) {
		tv.tv_sec = 10;
		tv.tv_usec = 0;
		FD_ZERO(&rfds);
		FD_SET(fd, &rfds);
		retval = select(fd_max, &rfds, NULL, NULL, &tv);
		if (retval) {
			if( FD_ISSET(fd, &rfds) ) {
				retval = read(fd, buf, count);
#ifdef DEBUG_MODE
				if (verbose_flag & PINFO) {
					int __i;
					PVERB(PINFO, 
					      "# camera_io_ib_server.c read <- ");
					for(__i=0;__i<retval;__i++)
						PVERB(PINFO, "0x%02x ",
						      *(((u_char *)buf)+__i) );
					PVERB(PINFO, "\n");
				}
#endif
				return retval;
			}
		}
	}		
	
	return -1; /* never */
}
	



int camera_core(int cam, int fd)
{
	struct ib_packet pk;
	struct cc_packet *ccp;
	int ret;
	int val;
	int len;
	int i;
	int send_d = -1;
	int send_addr = -1;
	int addr_to;
	char str[8];
	char *data_r = NULL;
	char *data_s = NULL;

	ccp = (struct cc_packet *)&pk.data;

	while (1){
		//usleep(100000);
		ret = soft_read(fd, &pk, sizeof(struct ib_packet_head) );
		if( pk.h.size > 0) {
			ret += soft_read(fd, &pk.data, pk.h.size );
		}
		switch (ccp->h.cmd) {
		case CC_GET_INT:
			ret = get_int_from_cc(cam, ccp->data, &val);
			if (ret != 0) {
				len = sizeof(struct cc_packet_head);
				len += sprintf(ccp->data, "%d",  val);
				ibus_send_data_to(fd, pk.h.addr, ccp, len);
			}
			break;
		case CC_GET_STR:
			len = ccp->h.size;
			sprintf(str,"%s", ccp->data);
			ret = get_str_from_cc(cam, str, ccp->data, len);
			if (ret != 0) {
				len += sizeof(struct cc_packet_head);
				ibus_send_data_to(fd, pk.h.addr, ccp, len);
			}
			break;
		case CC_PUT_INT:
		case CC_PUT_STR:
			put_str_to_cc(cam, &ccp->data[0], ccp->data+1);
			break;
		case CC_ACTION:
			action_to_cc(cam, ccp->data);
			break;

		case CC_SEND_DATA:
			if ( send_d == -1) {
				data_s = (char *) malloc(
					ccp->h.size * sizeof(char));
				send_addr = pk.h.addr;
				send_d = 0;
			}
			if ( pk.h.addr == send_addr && send_d != -1 && 
			     data_s == NULL) {
				len = pk.h.size - sizeof(struct cc_packet_head);
				memcpy(data_s+send_d, ccp->data, len);
				send_d+=len;
				if( send_d >= ccp->h.size ) {
					send_data_to_cc(cam, data_s, send_d);
					send_d = -1;
					free(data_s);
					data_s = NULL;
				}
			}
			break;

		case CC_RCV_DATA:
			data_r = (char *) malloc(ccp->h.size * sizeof(char));
			val = ccp->h.size;
			addr_to = pk.h.addr;
			ret = rcv_data_from_cc(cam, data_r, &val);
			
			for(i=0; i < val; i += CC_PACKET_DATA_LEN) {
				if( (val - i - CC_PACKET_DATA_LEN) > 0){
					len = CC_PACKET_DATA_LEN;
				}else{
					len = val - i;
				}
				memcpy(ccp->data, data_r+i, len);
				PVERB(PINFO,"[%d < %d: %d] -> 0x%x\n", 
				      i, val, len, addr_to); 
				len += sizeof(struct cc_packet_head);	
				ibus_send_data_to(fd, addr_to, ccp, len);
			}
			PVERB(PINFO,"[CC_RCV_DATA: stop]\n");
			free(data_r);
			data_r = NULL;
			break;
		case CC_RCV_SETUP:
			len = ccp->h.size;
			ret = rcv_setup_from_cc(cam, (struct camera_setup *)
						ccp->data); 
			if (ret == 0) {
				len += sizeof(struct cc_packet_head);
				ibus_send_data_to(fd, pk.h.addr, ccp, len);
			}
			break;
		case CC_RCV_MOUSE:
			len = ccp->h.size;
			ret = rcv_mouse_from_cc(cam, (struct mouse_pointer *)
						ccp->data); 
			if (ret == 0) {
				len += sizeof(struct cc_packet_head);
				ibus_send_data_to(fd, pk.h.addr, ccp, len);
			}
			break;
		default:
			PVERB(PERR," camera core: bad command from 0x%x\n",
			      pk.h.addr);
		}
	}

	return 0;
}
