/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/
#define _GNU_SOURCE

#include <unistd.h>
#define USE_IAR_BUS
#  include "camera.h"
#include "my_stdio.h"
#include "socket_client.h"
#include "iar_bus.h"


int open_camera(void)
{
	int dev;

	dev = call_socket(CAMERA_HOST_NAME, CAMERA_TCP_PORT);

	return dev;
}


int close_camera(int dev)
{
	ibus_remove( dev );
	return close(dev);
}
