/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdarg.h>
#include <unistd.h>
#include <malloc.h>
#include <gpib/ib.h>
#define HW_GPIB
#include "camera.h"
#include "my_stdio.h"
#include "camera_setup.h"


static int gpib_p_addr = -1;


int set_gpib_controller(int gpad)
{

#ifdef DEMO_MODE
	return 0;
#endif
	gpib_p_addr = gpad;
	/* Sets GPIB primary address */
	ibconfig(gpad, IbcPAD, 0);
	/* Sets GPIB secondary address */
	ibconfig(gpad, IbcSAD, 0);
	/* Sets timeout for io operations */
	ibconfig(gpad, IbcTMO, CC_TIME_OUT);
	/* If setting is nonzero, EOI is asserted with last byte on
           writes */
	ibconfig(gpad, IbcEOT, 1);
  	/* Automatic serial polling is disable */
	ibconfig(gpad, IbcAUTOPOLL, 0);
	//ibconfig(gpad, IbcSC, 1);
	ibconfig(gpad, IbcEOSrd, 0);
	ibconfig(gpad, IbcEOSwrt, 0);
	ibconfig(gpad, IbcEOScmp, 0);
	ibconfig(gpad, IbcEOSchar, 0x00);
	ibconfig(gpad, IbcTIMING, T1_DELAY_2000ns); /* FIXME T1_DELAY_350ns */

	return 0;
}


int wait_camera_controller_on(int pad)
{
	short listen;
	int done = 0;

	do{
		/* check if listener is present */
		ibln(gpib_p_addr, pad, NO_SAD, &listen );
#ifdef NI_NAT4882_ISA
		listen = 1;
#endif
		if(ibsta & ERR){
			if(iberr == EBUS){
				SYSLOG(LOG_ERR,
				       "Camera controller not found in primary address %d",
				       pad);
			}else{
				SYSLOG(LOG_ERR,"Camera: init error [0x%x]", iberr);
			}
		}else{
			if( ! listen ){
				SYSLOG(LOG_ERR,
				       "Camera controller not listen in primary address %d",
				       pad);
			}else{
				done = 1;
			}
		}
	}while(!done);

	return 0;
}


int open_camera_controller(int pad)
{
	int dev;

#ifdef DEMO_MODE
	return 1;
#endif

	dev = ibdev(gpib_p_addr, pad, 0, CC_TIME_OUT, 1, 0);
	if (dev < 0) {
	  return dev;
	}

	wait_camera_controller_on(pad);
	/* Sets timeout for io operations */
	ibconfig(dev, IbcTMO, CC_TIME_OUT);
	/* If setting is nonzero, EOI is asserted with last byte on
           writes */
	ibconfig(dev, IbcEOT, 1);
	ibconfig(dev, IbcEOSrd, 0);
	ibconfig(dev, IbcEOSwrt, 0);
	ibconfig(dev, IbcEOScmp, 0);
	ibconfig(dev, IbcEOSchar, 0x00);

	return dev;
}


int open_camera(void)
{
	int dev;

	set_gpib_controller(CC_GPIB);
	dev = open_camera_controller(CC_PADDR);
	if(dev >= 0) {
#ifdef NI_NAT4882_ISA
		/* Automatic serial polling is disable */
		ibconfig(gpib_p_addr, IbcAUTOPOLL, 0);
#endif
		if( camera_get_setup(dev, IMT_NONE) != 0) 
			return -1;
	}

	return dev;
}


int close_camera(int dev)
{
	/* FIXME */
	return 0;
}


