/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/

#ifndef _CAMERA_IB_PK_H
#define _CAMERA_IB_PK_H
#include <stdint.h>
#include "iar_bus.h"


#define CC_GET_INT    0x01
#define CC_GET_STR    0x02
#define CC_PUT_INT    0x03
#define CC_PUT_STR    0x04
#define CC_ACTION     0x05
#define CC_SEND_DATA  0x06
#define CC_RCV_DATA   0x07
#define CC_RCV_SETUP  0x08
#define CC_RCV_MOUSE  0x09


struct cc_packet_head {
	uint16_t cmd;
	uint32_t size;

};


#define CC_PACKET_DATA_LEN ( (int) IB_PACKET_DATA_LEN - (int) sizeof(struct cc_packet_head))


struct cc_packet {
	struct cc_packet_head h;
	char data[CC_PACKET_DATA_LEN];
};


#endif /* _CAMERA_IB_PK_H */
