/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/

#ifndef _CAMERA_HEADER_H
#define _CAMERA_HEADER_H

#include <stdint.h> /* for uintXX_t definition */


struct cc_image_head {
	char comment[36];
	char time_date[12];
	uint16_t exposure;
	uint16_t x0;
	uint16_t y0;
	uint16_t x_len;
	uint16_t y_len;
	uint16_t temperature;
	uint16_t gain;
	char unused[2];
};


#endif /* ifndef _CAMERA_HEADER_H */
