/** 
 *   Camera Control for STAR I.
 *
 *   (c) Copyright 2004 Federico Bareilles <fede@iar.unlp.edu.ar>,
 *   Instituto Argentino de Radio Astronomia (IAR).
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *     
 *   The author does NOT admit liability nor provide warranty for any
 *   of this software. This material is provided "AS-IS" in the hope
 *   that it may be useful for others.
 *
 **/

#ifndef _CAMERA_H
#define _CAMERA_H
#include "camera_setup.h"

#define CCD_Y_LEN 384
#define CCD_X_LEN 576

#ifdef NI_NAT4882_ISA
#  define WSR_USLEEP 100 /* Wait for Service Request usleep */
#endif

#ifdef HW_GPIB
#  include <gpib/ib.h>
#  define CC_TIME_OUT T100ms  /* T30ms or T100ms */

#  define CC_GPIB 0
#  define CC_PADDR 1
#  define CC_RETRY_GET 10
#endif

#ifdef USE_IAR_BUS
#  define CAMERA_SOCK_NAME /tmp/camera_bus
#  define CAMERA_TCP_PORT 3030
#  define CAMERA_HOST_NAME "127.0.0.1"
#  define CC_IB_ID 0x001
int camera_core(int cam, int fd);
#endif

struct mouse_pointer {
	int x;
	int y;
	int val;
};

/* camera_init_gpig */
#ifdef HW_GPIB
int set_gpib_controller(int gpad);
int wait_camera_controller_on(int pad);
int open_camera_controller(int pad);
extern struct camera_setup cam_setup;
#endif
int open_camera(void);
int close_camera(int dev);

/* camera_io_gpib */

#define CMD_OK    0x60
#define CMD_ERROR 0x40
#define RW_BUF_SIZE 80

int get_int_from_cc(int dev, char *cmd, int *val);
int get_str_from_cc(int dev, char *cmd, char *str, int len);
int put_int_to_cc(int dev, char *cmd, int val);
int put_str_to_cc(int dev, char *cmd, char *str);
int action_to_cc(int dev, char *cmd);
int send_data_to_cc(int dev, char *data, int len);
int rcv_data_from_cc(int dev, char *data, int *len);
int rcv_setup_from_cc(int dev, struct camera_setup *set);
int rcv_mouse_from_cc(int dev, struct mouse_pointer *set);

/* camera_cmd */
#include <time.h>
#include "camera_header.h"

#define GAIN_HIGH    1
#define GAIN_LOW     0
#define TEMP_REG_ON  1
#define TEMP_REG_OFF 0
#define ZOOM_1X      0
#define ZOOM_2X      1
#define ZOOM_3X      2
#define AUTO_WIN_ON  1
#define AUTO_WIN_OFF 0

int cc_get_exposure_time(int dev, int *time);
int cc_set_exposure_time(int dev, int time);
int cc_get_gain(int dev, int *gain);
int cc_set_gain(int dev, int gain);
int cc_get_temp_regulation(int dev, int *temp);
int cc_set_temp_regulation(int dev, int temp);
int cc_get_box_y0(int dev, int *y);
int cc_set_box_y0(int dev, int y);
int cc_get_box_x0(int dev, int *x);
int cc_set_box_x0(int dev, int x);
int cc_get_box_y_len(int dev, int *y);
int cc_set_box_y_len(int dev, int y);
int cc_get_box_x_len(int dev, int *x);
int cc_set_box_x_len(int dev, int x);
int cc_get_zoom_factor(int dev, int *z);
int cc_set_zoom_factor(int dev, int z);
int cc_get_auto_win(int dev, int *w);
int cc_set_auto_win(int dev, int w);
int cc_get_date_time(int dev, time_t *time);
int cc_set_date_time(int dev, time_t time);
int cc_get_win_max(int dev, int *w);
int cc_set_win_max(int dev, int w);
int cc_get_win_min(int dev, int *w);
int cc_set_win_min(int dev, int w);
int cc_get_cc_header(int dev, struct cc_image_head *h);
int cc_set_cc_header(int dev, struct cc_image_head h);
int cc_get_binning(int dev, int *b);
int cc_set_binning(int dev, int b);
int cc_get_roi_index(int dev, int *i);
int cc_set_roi_index(int dev, int i);
int cc_get_roi_delay(int dev, int *d);
int cc_set_roi_delay(int dev, int d);
int cc_get_temperature(int dev, int *t);
int cc_act_exposure(int dev);
int cc_act_dark(int dev);
int cc_act_bias(int dev);
int cc_act_focus(int dev);
int cc_act_triger(int dev);
int cc_act_shade(int dev);
int cc_act_clear(int dev);
int cc_act_create_lut(int dev);
int cc_act_send_data(int dev, int *data, int len);
int cc_act_rcv_data(int dev, int *data, int *len);
int cc_act_rcv_setup(int dev, struct camera_setup *set);
int cc_act_rcv_mouse_xyz(int dev, struct mouse_pointer *mp);
int cc_act_set_box(int dev);
int cc_act_get_box(int dev);
int cc_act_send_lut(int dev, char *lut);
int cc_act_roi_acquisition(int dev);
int cc_act_move_mouse(int dev, int x_delta, int y_delta);


#endif /* ifndef _CAMERA_H */
